/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.resource;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.tacz.guns.crafting.GunSmithTableRecipe;
import com.tacz.guns.resource.pojo.data.attachment.AttachmentData;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_2960;

public enum CommonAssetManager {
    INSTANCE;

    private final Map<class_2960, GunData> gunData = Maps.newHashMap();
    private final Map<class_2960, AttachmentData> attachmentData = Maps.newHashMap();
    private final Map<class_2960, GunSmithTableRecipe> gunSmithTableRecipes = Maps.newHashMap();
    private final Map<class_2960, Set<String>> attachmentTags = Maps.newHashMap();
    private final Map<class_2960, Set<String>> allowAttachmentTags = Maps.newHashMap();

    public void putGunData(class_2960 registryName, GunData data) {
        this.gunData.put(registryName, data);
    }

    public GunData getGunData(class_2960 registryName) {
        return this.gunData.get(registryName);
    }

    public void putAttachmentData(class_2960 registryName, AttachmentData data) {
        this.attachmentData.put(registryName, data);
    }

    public AttachmentData getAttachmentData(class_2960 registryName) {
        return this.attachmentData.get(registryName);
    }

    public void putRecipe(class_2960 registryName, GunSmithTableRecipe recipe) {
        this.gunSmithTableRecipes.put(registryName, recipe);
    }

    public Optional<GunSmithTableRecipe> getRecipe(class_2960 recipeId) {
        return Optional.ofNullable(this.gunSmithTableRecipes.get(recipeId));
    }

    public Map<class_2960, GunSmithTableRecipe> getAllRecipes() {
        return this.gunSmithTableRecipes;
    }

    public void putAttachmentTags(class_2960 registryName, List<String> tags) {
        this.attachmentTags.computeIfAbsent(registryName, id -> Sets.newHashSet()).addAll(tags);
    }

    public Set<String> getAttachmentTags(class_2960 registryName) {
        return this.attachmentTags.get(registryName);
    }

    public void putAllowAttachmentTags(class_2960 registryName, List<String> tags) {
        this.allowAttachmentTags.computeIfAbsent(registryName, id -> Sets.newHashSet()).addAll(tags);
    }

    public Set<String> getAllowAttachmentTags(class_2960 registryName) {
        return this.allowAttachmentTags.get(registryName);
    }

    public void clearAll() {
        this.gunData.clear();
        this.attachmentData.clear();
        this.attachmentTags.clear();
        this.allowAttachmentTags.clear();
    }

    public void clearRecipes() {
        this.gunSmithTableRecipes.clear();
    }
}

